<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../../componenti/include/includeBaseComponenti.php";
    // solo i super admin hanno accesso agli strumenti
    if($_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>Amministrazione di Geecom Doc - informazioni di sistema</title>

    <?php
        include "../../componenti/include/cssBaseComponenti.php";
    ?>
	  
  </head>
  <body>
    
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
	  
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <?php 
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==200) {
                                echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Storico operazioni svuotato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                            }
                        }
                    ?>
                    <div class="row">
                        <div class="col-md-6">                            
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header">
                                    <span class="card-title align-self-center my-0">Informazioni di sistema</span>
                                </div>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><strong>Indirizzo IP:</strong> <?= $_SERVER["SERVER_ADDR"] ?></li>
                                    <li class="list-group-item">
                                        <strong>Server web:</strong> 
                                        <?php
                                            $arrApache = explode(")",$_SERVER["SERVER_SOFTWARE"]);
                                            echo $arrApache[0].")";
                                        ?>
                                    </li>
                                    <li class="list-group-item <?php echo((phpversion()<7.3) ? "text-danger" : "") ?>"><strong>Versione PHP:</strong> <?= phpversion() ?> <?= ((phpversion()<7.3) ? "<b>Troppo vecchia per Geecom!</b> È richiesta almeno la versione 7.3" : "") ?> </li>
                                    <?php
                                        // stampo i dati relativi a mysql
                                        $versioneMysql      = $geecomDb->getInformazioniServer();
                                        $arrayVersioneMysql = explode("-", $versioneMysql);
                                    ?>
                                    <li class="list-group-item <?php echo(($arrayVersioneMysql[0]<10) ? "text-danger" : "") ?>">
                                        <?php
                                            if($arrayVersioneMysql[0]<10) {
                                                echo "<strong>Versione MySql:</strong> $versioneMysql <b>Troppo vecchia per Geecom!</b> È richiesta almeno la versione 10";
                                            }
                                            else {
                                                echo "<strong>Versione MySql:</strong> $versioneMysql";                                                
                                            }
                                        ?>
                                    </li>
                                    <li class="list-group-item"><strong>Dimensione massima upload</strong> <?= (int)ini_get("upload_max_filesize") ?> Mb</li>
                                    <li class="list-group-item"><strong>Tempo massimo di esecuzione</strong> <?= (int)ini_get("max_execution_time") ?> s</li>
                                    <li class="list-group-item"><strong>Data e ora del sistema</strong> <?= date("d/m/Y H:i") ?></li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card mb-3 box-shadow-lite">
                                <div class="card-header">
                                    <span class="card-title align-self-center my-0">Estensioni php necessarie al funzionamento di Geecom CMS:</span>
                                </div>
                                <ul class="list-group list-group-flush">
                                    <?php
                                        $estensioniNecessarie      = array("gettext","mysqli","zip");
                                        $arrayEstensioniInstallate = get_loaded_extensions();
                                        foreach($estensioniNecessarie as $estensione) {
                                            if(in_array($estensione, $arrayEstensioniInstallate)) {
                                                ?>
                                                <li class="list-group-item"><strong><?php echo $estensione ?>:</strong> <span class="text-success">installata</span></li>
                                                <?php
                                            }
                                            else {
                                                ?>
                                                <li class="list-group-item"><strong><?php echo $estensione ?>:</strong> <span class="text-danger">non installata</span></li>
                                                <?php
                                            }
                                        }
                                    ?>
                                </ul>
                            </div>
                            
                            <div class="card mb-3 box-shadow-lite">
                                <div class="card-header">
                                    <span class="card-title align-self-center my-0">Manipolazione immagini:</span>
                                </div>
                                <ul class="list-group list-group-flush">
                                    <?php
                                        $datiGd = gd_info();
                                    ?>
                                    <li class="list-group-item"><strong>Manipolazione immagini JPG:</strong> <span class="text-<?php echo(($datiGd["JPEG Support"]==1) ? "success" : "danger") ?>"><?php echo(($datiGd["JPEG Support"]==1) ? "abilitata" : "non abilitata") ?></span></li>
                                    <li class="list-group-item"><strong>Manipolazione immagini PNG:</strong> <span class="text-<?php echo(($datiGd["PNG Support"]==1) ? "success" : "danger") ?>"><?php echo(($datiGd["PNG Support"]==1) ? "abilitata" : "non abilitata") ?></span></li>       
                                    <li class="list-group-item"><strong>Manipolazione immagini Webp:</strong> <span class="text-<?= ((isset($datiGd["WebP Support"]) && $datiGd["WebP Support"]==1) ? "success" : "danger") ?>"><?= ((isset($datiGd["WebP Support"]) && $datiGd["WebP Support"]==1) ? "abilitata" : "non abilitata") ?></span></li>
                                </ul>
                            </div>
                        </div>
                        

                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
                
        include "../../componenti/include/jsBaseComponenti.php";
        
        function contaFile($fileCsv,$stringaFile) {
            $numeroFile = 0;
            foreach($fileCsv as $file) {
                if($file!="." && $file!=".." && strpos($file,"$stringaFile")>0) {
                    $numeroFile++;
                }
            }
            return $numeroFile;
        }
    ?>
        <script>
            function mostraSelectGruppi() {
                var tabellaImportazione = document.getElementById("tabellaImportazione").value;
                
                if(tabellaImportazione == "geec_utenti") { 
                    document.getElementById("divSelectGruppo").className = "form-group";
                }
                else { 
                    document.getElementById("divSelectGruppo").className = "d-none";
                }
            }
        </script>
	  
  </body>
</html>